@echo off

REM This program requires that "ODDWORLD: New 'n' Tasty" (Steam) and "RAD Video Tools for Windows" have been installed successfully:
REM ODDWORLD: NEW 'n' Tasty:     http://store.steampowered.com/app/314660/
REM RAD Video Tools for Windows: http://www.radgametools.com/bnkdown.htm

REM The following four variables need to be set according to your system environment to get the program to work.

REM Please adjust "SteamDir" to the main directory of the Steam application (please do not forget to add backslash at the end of the path):
set SteamDir=C:\Program Files (x86)\Steam\

REM Please adjust "RADToolsDir" to the directory of the RAD Video Tools (please do not forget to add backslash at the end of the path):
set RADToolsDir=C:\Program Files (x86)\RADVideo\

REM Please adjust "BinkPlayer" to the EXE file of the desired Bink Player (32-bit systems: binkplay.exe / 64-bit systems: binkpl64.exe):
set BinkPlayer=binkpl64.exe

REM The variable "MovieSubDir" is responsible to select the correct video files.
REM If you have used "ONnT-Conversion.bat" to convert the original cutscene video files to videos with smaller resolution, "MovieSubDir" needs to be "!Original".
REM If you still use the videos with their original resolution, please add "REM " at the beginning of the next line and remove "REM " from the line after next line.
set MovieSubDir=\!Original
REM set MovieSubDir=

REM The variable "DisplayWidth" is required for correct Full-Screen playback of the videos.
REM Please set it to the width of your current display resolution.
set /A DisplayWidth=1920

REM The variable "BinkHeight" depends on "DisplayWidth" (see above).
REM The original cutscene videos have a resolution of 1920 x 1080 pixels and therefore an aspect ratio of 1.777777777777778:1.
REM For example, if your display has a resolution of 1680 x 1050 pixels, "BinkHeight" needs to be 945 for the correct aspect ratio (1680/1.777777777777778=945).
REM This batch file will adjust "BinkHeight" for the following display widths automatically: 1024, 1152, 1280, 1360, 1366, 1440, 1600, 1680, 1920, 2048, 2560 and 3840.
REM This should cover most common displays. If your display has any other display width, please adjust "BinkHeight" accordingly.
REM Just perform the following calculation and enter the resulting value below: Your display width / 1.777777777777778 = result.
set /A BinkHeight=1080

if %DisplayWidth%==1024 (
  set /A BinkHeight=576
)
if %DisplayWidth%==1152 (
  set /A BinkHeight=648
)
if %DisplayWidth%==1280 (
  set /A BinkHeight=720
)
if %DisplayWidth%==1360 (
  set /A BinkHeight=765
)
if %DisplayWidth%==1366 (
  set /A BinkHeight=768
)
if %DisplayWidth%==1440 (
  set /A BinkHeight=810
)
if %DisplayWidth%==1600 (
  set /A BinkHeight=900
)
if %DisplayWidth%==1680 (
  set /A BinkHeight=945
)
if %DisplayWidth%==1920 (
  set /A BinkHeight=1080
)
if %DisplayWidth%==2048 (
  set /A BinkHeight=1152
)
if %DisplayWidth%==2560 (
  set /A BinkHeight=1440
)
if %DisplayWidth%==3840 (
  set /A BinkHeight=2160
)

REM Additional information:
REM The variable "BinkCommand" are the command line switches of the selected Bink Player.
REM By double-clicking on the desired Bink Player EXE file, a window will open showing all available switches.
REM Please adjust "BinkCommand", if required on your system.
set BinkCommand=/W%DisplayWidth% /H%BinkHeight% /R /C /U8

mode 42, 37
color 73
set Bink="%RADToolsDir%%BinkPlayer%"
set NnTDir="%SteamDir%steamapps\common\Oddworld New n Tasty\NNT_Data\StreamingAssets\Movies%MovieSubDir%"

cd /D %NnTDir%
goto Main

:Main
cls
echo.
echo          ODDWORLD:  New 'n' Tasty
echo          ========================
echo.
echo           Alternate Movie Player
echo.
echo.
echo      1 -  Legal Information
echo      2 -  Abe and Logos
echo      3 -  This is RuptureFarms
echo      4 -  Scrab Scare
echo      5 -  Molluck Watches #1
echo      6 -  Abe and the Moon
echo      7 -  Paramonia Intro
echo      8 -  Paramonia Temple
echo      9 -  Paramonia Scar - Version #1
echo      A -  Paramonia Scar - Version #2
echo      B -  Scrabania Intro
echo      C -  Scrabania Temple
echo      D -  Scrabania Scar - Version #1
echo      E -  Scrabania Scar - Version #2
echo      F -  Shrykull Transformation
echo      G -  The Factory Halts
echo      H -  Molluck Watches #2
echo      I -  What a Drag
echo      J -  Bad Ending
echo      K -  Good Ending
echo      L -  Credits
echo      M -  Attract Video
echo.
echo      X -  Exit
echo.
echo.
choice /C 123456789ABCDEFGHIJKLMX /N /M "-> Please select: "

if errorlevel 23 goto End
if errorlevel 22 goto Attract
if errorlevel 21 goto Credits
if errorlevel 20 goto GoodEnd
if errorlevel 19 goto BadEnd
if errorlevel 18 goto WaD
if errorlevel 17 goto MW2
if errorlevel 16 goto TFH
if errorlevel 15 goto ShT
if errorlevel 14 goto ScSc2
if errorlevel 13 goto ScSc1
if errorlevel 12 goto ST
if errorlevel 11 goto SI
if errorlevel 10 goto PS2
if errorlevel 9 goto PS1
if errorlevel 8 goto PT
if errorlevel 7 goto PI
if errorlevel 6 goto AatM
if errorlevel 5 goto MW1
if errorlevel 4 goto ScSc
if errorlevel 3 goto TiRF
if errorlevel 2 goto Logo
if errorlevel 1 goto Legal
goto main

:Legal
cls
start /w "" %Bink% %BinkCommand% Legal.bk2
goto Main

:Logo
start /w "" %Bink% %BinkCommand% Logo.bk2
goto Main

:TiRF
start /w "" %Bink% %BinkCommand% RFIntro.bk2
goto Main

:ScSc
start /w "" %Bink% %BinkCommand% ScrabScare.bk2
goto Main

:MW1
start /w "" %Bink% %BinkCommand% MolluckWatches.bk2
goto Main

:AatM
start /w "" %Bink% %BinkCommand% AbeMoon.bk2
goto Main

:PI
start /w "" %Bink% %BinkCommand% ParamoniaIntro.bk2
goto Main

:PT
start /w "" %Bink% %BinkCommand% ParamoniaTemple.bk2
goto Main

:PS1
start /w "" %Bink% %BinkCommand% ParamoniaScar.bk2
goto Main

:PS2
start /w "" %Bink% %BinkCommand% ParamoniaScar2.bk2
goto Main

:SI
start /w "" %Bink% %BinkCommand% ScrabaniaIntro.bk2
goto Main

:ST
start /w "" %Bink% %BinkCommand% ScrabaniaTemple.bk2
goto Main

:ScSc1
start /w "" %Bink% %BinkCommand% ScrabaniaScar.bk2
goto Main

:ScSc2
start /w "" %Bink% %BinkCommand% ScrabaniaScar2.bk2
goto Main

:ShT
start /w "" %Bink% %BinkCommand% ShrkullTransform.bk2
goto Main

:TFH
start /w "" %Bink% %BinkCommand% TheFactoryHalts.bk2
goto Main

:MW2
start /w "" %Bink% %BinkCommand% MolluckWatches2.bk2
goto Main

:WaD
start /w "" %Bink% %BinkCommand% WhatADrag.bk2
goto Main

:BadEnd
start /w "" %Bink% %BinkCommand% BadEnding.bk2
goto Main

:GoodEnd
start /w "" %Bink% %BinkCommand% GoodEnding.bk2
goto Main

:Credits
start /w "" %Bink% %BinkCommand% Credits.bk2
goto Main

:Attract
start /w "" %Bink% %BinkCommand% Attract.bk2
goto Main

:End
cls
exit
