#include "path.h"
#include <map>
/*
This path parsing function is wired to decode Path1 of R1. 
TODO list:
-Write a unit test to ensure decoder dosent break
-Refactor decoder to be human readable
-figure out how positions of objects are set? seems to be in a seperate function maybe?
-figure out where collision per cam is set? also a diff function?
-figure out how the format works, how can we insert or remove a script item? or change a script item?
*/

struct THeader
{
	unsigned int iSegmentSize;	// Size of chunk
	unsigned int iRefCount;		// Num times loaded (0 in file)
	unsigned int iType;			// Type "Path" in this case
	unsigned int iId;			// Resource id, 0xF in this case
};

struct THardCodedMagic
{
	unsigned int iAfterCamNamesMagic;
	unsigned int iNearEndOfFileMagic;
};

const THardCodedMagic KHardCodedMagic = {0x724, 0x2DE4 };
const unsigned int KHeaderSize = sizeof( THeader );

int main( char**, int )
{
	// Open the file
	std::ifstream f;
	f.open( _T("R1PATH.PATH1"), std::ios::binary );
	if ( !f.is_open() )
	{
		std::cout <<"Can't open the file for reading\n";
		return 1;
	}

	// Get the file size
	f.seekg(0, std::ios_base::beg);
	std::ifstream::pos_type begin_pos = f.tellg();
	f.seekg(0, std::ios_base::end);
	int fileSize = static_cast<int>(f.tellg() - begin_pos);
	f.seekg(0, std::ios_base::beg);
	if ( !fileSize )
	{
		std::cout << "Can't get the file size\n";
		return 1;
	}

	// Load the file into a vector
	std::vector< unsigned char > data;
	data.resize( fileSize );
	f.read( reinterpret_cast< char* > ( &data[0] ), fileSize );

	for ( unsigned int i=0; i<20; i++ )
	{
		/* Known params:
		
		// Loading, to S1
		iterationIndex_q = 0
		aPathItemIndex = 1
		pathItemsCount = 0xC

		iterationIndex_q = 0
		aPathItemIndex = 2
		pathItemsCount = 0xC

		iterationIndex_q = 1
		aPathItemIndex = 1
		pathItemsCount = 0xC

		iterationIndex_q = 0
		aPathItemIndex = 1
		pathItemsCount = 0xC

		0, 1, 1, FFFF
		0, 2, 1, FFFF
		1, 1
		0,1

		// S1 to S2
		iterationIndex_q = 0
		aPathItemIndex = 3
		pathItemsCount = 0xC

		iterationIndex_q = 0
		aPathItemIndex = 2
		pathItemsCount = 0xC

		0,3
		0,2

		// S2 to S3
		0,4
		0,3

		// S3 to S4
		0,5
		0,4

		// S4 to S5
		0,6
		1,5
		0,5

		// S5 to S6
		0,7
		1,6
		0,6
		
		// S6 to S7
		0,8
		0,7

		// S7 to S8
		0,9
		1,8
		0,8

		// S8 to S9
		1,9
		0,9

		// S9 to B9
		1,8
		1,9



		*/

	//ParsePath( &data[0], i, -1 );
	}

	// Loading to S1
	std::cout << "\nLoading to S1\n";
	ParsePath( &data[0], 0, 1, 1, -1 );
	ParsePath( &data[0], 0, 2, 1, -1 );
	ParsePath( &data[0], 1, 1, 1, -1 );
	ParsePath( &data[0], 0, 1, 1, -1 );

	// S1 to B1
	// 2, 1
	// 1, 1
	std::cout << "\nS1 to B1\n";
	ParsePath( &data[0], 2, 1, 1, -1 );
	ParsePath( &data[0], 1, 1, 1, -1 );

	// B1 to B2
	// 2,1


	// S1 to S2
	std::cout << "\nS1 to S2\n";
	ParsePath( &data[0], 0, 3, 1, -1 );
	ParsePath( &data[0], 0, 2, 1, -1 );

	// S2 to S3
	std::cout << "\nS2 to S3\n";
	ParsePath( &data[0], 0, 4, 1, -1 );
	ParsePath( &data[0], 0, 3, 1, -1 );

	// S3 to S4
	std::cout << "\nS3 to S4\n";
	ParsePath( &data[0], 0, 5, 1, -1 );
	ParsePath( &data[0], 0, 4, 1, -1 );

	/*
		// S4 to S5
		0,6
		1,5
		0,5

		// S5 to S6
		0,7
		1,6
		0,6
		
		// S6 to S7
		0,8
		0,7

		// S7 to S8
		0,9
		1,8
		0,8
	*/

	// Exit
	return 0;
}

void ParsePath( unsigned char* aBuffer, unsigned int aIndex, unsigned int aIteration, unsigned int aArg3, unsigned int aArg4 )
{
	// Dump the header info
	THeader* header = reinterpret_cast< THeader* > ( aBuffer ); // Hack, assume no padding between struct etc
	/*
	std::cout << "iSegmentSize = " << header->iSegmentSize << "\n";
	std::cout << "iRefCount = " << header->iRefCount << "\n";
	std::cout << "iType = " << header->iType << "\n";
	std::cout << "iId = " << header->iId << "\n";
	*/

	//unsigned int aArg4 = -1; // TODO Appears to be 0xFFFF / -1 so far?
	//unsigned int aArg3 = 1;  // TODO Appears to be 1 in the test case?

	std::cout << "aIndex: " << aIndex << " aIteration: " <<  aIteration << " Arg3: " << std::hex << aArg3 << " Arg4: " <<  std::hex << aArg4 << "\n";


	// Get the dword at the magic offset plus the function param
	int v = (( 0xC * aIndex ) + aIteration );	// Very magic formula to get the script for a given screen

	unsigned int endOfFileTableDWord = ((unsigned int*)aBuffer)
		[ (
				KHardCodedMagic.iNearEndOfFileMagic +  
				( v * sizeof ( unsigned int ) ) + 
				KHeaderSize  ) / 4 ]; // TODO CAST POINTER!

	/*
		iterationIndex_q = 0
		aPathItemIndex = 1
		pathItemsCount = 0xC

		iterationIndex_q = 0
		aPathItemIndex = 2
		pathItemsCount = 0xC

		iterationIndex_q = 1
		aPathItemIndex = 1
		pathItemsCount = 0xC

		iterationIndex_q = 0
		aPathItemIndex = 1
		pathItemsCount = 0xC
	*/
	 

	unsigned char* ptr  = &aBuffer[KHardCodedMagic.iAfterCamNamesMagic + endOfFileTableDWord + KHeaderSize];


  int pathId = header->iId; /*this->iPath;*/
  //funcPtr_base_q = this->iPathFuncPtrsBase;
  //vtbl = funcPtr_base_q;
//  *(_DWORD *)&low_path = **(&thisPtr->iPathDataPtr_q + pathId);
  unsigned int path_word_q = /**(_DWORD *)(*(_DWORD *)(funcPtr_base_q + 24)
                          + 4 * (aPathItemIndex + iterationIndex_q * thisPtr->isShryPort)
                          + *(_DWORD *)&low_path);*/ endOfFileTableDWord; /* + (  aIndex + aIteration * 0xc );*/

 
  if ( path_word_q != 0xFFFFFFFF )
  {
    if ( path_word_q < 0x100000 )
    {
	  /*
      pathBuffer = (BYTE *)(*(_DWORD *)&low_path + path_word_q + *(_DWORD *)(funcPtr_base_q + 20));
      low_path = *((_WORD *)pathBuffer + 1);
      */
      unsigned char* pathBuffer = (unsigned char*)ptr;
	  unsigned int low_path = *((unsigned short int*)ptr+1);

	  if ( low_path < 0x18u || low_path > 0x1E0u )
	  {
		std::cout << "SET BIT 4\n";
        *pathBuffer |= 4u;                      // Mark as used
	  }


      if ( *((unsigned int *)pathBuffer + 1) <= (signed int)0x100000u ) // 2nd dword
      {
        if ( low_path <= 0x2000u )
        {
          if ( *((unsigned int *)pathBuffer + 2) <= (signed int)0x1000000u ) // 3rd dword
          {
            while ( 1 )
            {
              if ( aArg4 == -1 || aArg4 == *((unsigned int *)pathBuffer + 1) )// Arg4 is usally 8?
              {
                if ( aArg3 || !(*pathBuffer & 3) )// if opcode 
                {
					unsigned int opcode = *(unsigned int*)(pathBuffer + 4);
					LogOpcode( opcode );
					/* This is excuting the op code.
                  (*(void (__cdecl **)(BYTE *, g_global_ban_class *, unsigned int, _DWORD))(vtbl
                                                                                          + 4
                                                                                          * *((_DWORD *)pathBuffer + 1)
                                                                                          + 28))(
                    pathBuffer,
                    thisPtr,
                    path_word_q | ((thisPtr->iLevel | (thisPtr->iPath << 8)) << 16),// 16 bits path word, 8 bits level id, 8 bits path id
                    aArg3);
					*/
                  if ( !aArg3 )
				  {
				    std::cout << "SET BIT 3\n";
                    *pathBuffer |= 3u;          // Mark as loaded
				  }
                }
              }
              
			  //LOBYTE(low_path) = (*pathBuffer >> 2);
              unsigned char* low_path_byte1 = ((unsigned char*)&low_path);
			  *low_path_byte1= (*pathBuffer >> 2);

			  if ( low_path & 1 )
			  {
				  std::cout << "EXIT LOOP!\n";
                break;
			  }

              int pathWord = *((unsigned short int *)pathBuffer + 1);
              pathBuffer += pathWord;
              path_word_q += pathWord;
              unsigned short int pathWordToCheck = *((unsigned short int *)pathBuffer + 1);
              
			  if ( pathWordToCheck < 0x18u || pathWordToCheck > 0x1E0u )
			  {
				std::cout << "SET BIT 4\n";
                *pathBuffer |= 4u;              // Mark as used
			  }

            }  // while (1 )
          } // if ( *((_DWORD *)pathBuffer + 2) <= (signed int)0x1000000u ) // 3rd dword
        } // if ( low_path <= 0x2000u )
      } //  if ( *((_DWORD *)pathBuffer + 1) <= (signed int)0x100000u ) // 2nd dword
    } // if ( path_word_q < 0x100000 )
  } // if ( path_word_q != 0xFFFFFFFF )
  //return low_path;
}

void LogOpcode( unsigned int aOpcode )
{
	std::map< unsigned int, std::string > opCodeNameMap;

	opCodeNameMap.insert( std::make_pair( 0, "load_null" ) );
	opCodeNameMap.insert( std::make_pair( 1, "load_null_0" ) );
	opCodeNameMap.insert( std::make_pair( 2, "load_null_1" ) );
	opCodeNameMap.insert( std::make_pair( 3, "load_hoist_rocks" ) );
	opCodeNameMap.insert( std::make_pair( 4, "load_hosit_or_edge_ban" ) );
	opCodeNameMap.insert( std::make_pair( 5, "load_null_2" ) );
	opCodeNameMap.insert( std::make_pair( 6, "load_door_bans" ) );
	opCodeNameMap.insert( std::make_pair( 7, "load_unknown" ) );
	opCodeNameMap.insert( std::make_pair( 8, "load_lifts_ban" ) );
	opCodeNameMap.insert( std::make_pair( 9, "load_null_3" ) );
	opCodeNameMap.insert( std::make_pair( 10, "load_null_4" ) );
	opCodeNameMap.insert( std::make_pair( 11, "load_well_ban" ) );
	opCodeNameMap.insert( std::make_pair( 12, "load_unknown_ban_q" ) );
	opCodeNameMap.insert( std::make_pair( 13, "load_bans_17" ) );
	opCodeNameMap.insert( std::make_pair( 14, "load_bans_18" ) );
	opCodeNameMap.insert( std::make_pair( 15, "load_bans_19" ) );
	opCodeNameMap.insert( std::make_pair( 16, "load_null_5" ) );
	opCodeNameMap.insert( std::make_pair( 17, "load_null_6" ) );
	opCodeNameMap.insert( std::make_pair( 18, "load_bans_20" ) );
	opCodeNameMap.insert( std::make_pair( 19, "load_unknown_0" ) );
	opCodeNameMap.insert( std::make_pair( 20, "load_elum_bans" ) );
	opCodeNameMap.insert( std::make_pair( 21, "load_null_7" ) );
	opCodeNameMap.insert( std::make_pair( 22, "load_bans_16" ) );
	opCodeNameMap.insert( std::make_pair( 23, "load_null_8" ) );
	opCodeNameMap.insert( std::make_pair( 24, "load_slig_bans" ) );
	opCodeNameMap.insert( std::make_pair( 25, "load_slog_bans2" ) );
	opCodeNameMap.insert( std::make_pair( 26, "load_switch_bans" ) );
	opCodeNameMap.insert( std::make_pair( 27, "load_elum_bans_q" ) );
	opCodeNameMap.insert( std::make_pair( 28, "load_null_9" ) );
	opCodeNameMap.insert( std::make_pair( 29, "load_bans_12" ) );
	opCodeNameMap.insert( std::make_pair( 30, "load_null_10" ) );
	opCodeNameMap.insert( std::make_pair( 31, "load_null_11" ) );
	opCodeNameMap.insert( std::make_pair( 32, "load_abe_sick_or_lift_ban" ) );
	opCodeNameMap.insert( std::make_pair( 33, "load_null_38" ) );
	opCodeNameMap.insert( std::make_pair( 34, "load_abe_wasp" ) );
	opCodeNameMap.insert( std::make_pair( 35, "load_null_12" ) );
	opCodeNameMap.insert( std::make_pair( 36, "load_honey_ban" ) );
	opCodeNameMap.insert( std::make_pair( 37, "load_unknown_1" ) );
	opCodeNameMap.insert( std::make_pair( 38, "load_null_13" ) );
	opCodeNameMap.insert( std::make_pair( 39, "load_null_14" ) );
	opCodeNameMap.insert( std::make_pair( 40, "load_bans_2" ) );
	opCodeNameMap.insert( std::make_pair( 41, "load_unknown_bans" ) );
	opCodeNameMap.insert( std::make_pair( 42, "load_null_15" ) );
	opCodeNameMap.insert( std::make_pair( 43, "load_wasp_Bans" ) );
	opCodeNameMap.insert( std::make_pair( 44, "load_null_16" ) );
	opCodeNameMap.insert( std::make_pair( 45, "load_well_ban_proxy" ) );
	opCodeNameMap.insert( std::make_pair( 46, "load_bans_15" ) );
	opCodeNameMap.insert( std::make_pair( 47, "load_bans_14" ) );
	opCodeNameMap.insert( std::make_pair( 48, "load_paramite_ban" ) );
	opCodeNameMap.insert( std::make_pair( 49, "load_bans_11" ) );
	opCodeNameMap.insert( std::make_pair( 50, "load_abe_bans" ) );
	opCodeNameMap.insert( std::make_pair( 51, "load_null_17" ) );
	opCodeNameMap.insert( std::make_pair( 52, "load_portals" ) );
	opCodeNameMap.insert( std::make_pair( 53, "load_null_18" ) );
	opCodeNameMap.insert( std::make_pair( 54, "load_unknown_2" ) );
	opCodeNameMap.insert( std::make_pair( 55, "load_trap_bans" ) );
	opCodeNameMap.insert( std::make_pair( 56, "load_bans_9" ) );
	opCodeNameMap.insert( std::make_pair( 57, "load_slig_bans2" ) );
	opCodeNameMap.insert( std::make_pair( 58, "load_null_19" ) );
	opCodeNameMap.insert( std::make_pair( 59, "load_f2_ban" ) );
	opCodeNameMap.insert( std::make_pair( 60, "load_trigger_ban" ) );
	opCodeNameMap.insert( std::make_pair( 61, "load_bans_8" ) );
	opCodeNameMap.insert( std::make_pair( 62, "load_unknown_bans_0" ) );
	opCodeNameMap.insert( std::make_pair( 63, "load_null_20" ) );
	opCodeNameMap.insert( std::make_pair( 64, "load_null_21" ) );
	opCodeNameMap.insert( std::make_pair( 65, "load_null_22" ) );
	opCodeNameMap.insert( std::make_pair( 66, "load_slig" ) );
	opCodeNameMap.insert( std::make_pair( 67, "load_unknown_bans_1" ) );
	opCodeNameMap.insert( std::make_pair( 68, "load_unknown_3" ) );
	opCodeNameMap.insert( std::make_pair( 69, "load_unknown_bans_2" ) );
	opCodeNameMap.insert( std::make_pair( 70, "load_bans_3" ) );
	opCodeNameMap.insert( std::make_pair( 71, "load_throw_bag_bans" ) );
	opCodeNameMap.insert( std::make_pair( 72, "load_scrab_bans" ) );
	opCodeNameMap.insert( std::make_pair( 73, "load_fire_ban" ) );
	opCodeNameMap.insert( std::make_pair( 74, "load_null_23" ) );
	opCodeNameMap.insert( std::make_pair( 75, "load_null_24" ) );				
	opCodeNameMap.insert( std::make_pair( 76, "load_slig_bans2_proxy" ) );
	opCodeNameMap.insert( std::make_pair( 77, "load_null_25" ) );
	opCodeNameMap.insert( std::make_pair( 78, "load_null_26" ) );
	opCodeNameMap.insert( std::make_pair( 79, "load_null_27" ) );
	opCodeNameMap.insert( std::make_pair( 80, "load_null_28" ) );
	opCodeNameMap.insert( std::make_pair( 81, "load_unknown_4" ) );
	opCodeNameMap.insert( std::make_pair( 82, "load_mud" ) );
	opCodeNameMap.insert( std::make_pair( 83, "load_null_29" ) );
	opCodeNameMap.insert( std::make_pair( 84, "load_glow_fire_bans" ) );
	opCodeNameMap.insert( std::make_pair( 85, "load_unknown_5" ) );
	opCodeNameMap.insert( std::make_pair( 86, "load_bans_13" ) );
	opCodeNameMap.insert( std::make_pair( 87, "load_null_30" ) );
	opCodeNameMap.insert( std::make_pair( 88, "load_meat_saw" ) );
	opCodeNameMap.insert( std::make_pair( 89, "load_null_31" ) );
	opCodeNameMap.insert( std::make_pair( 90, "load_start_anim_q" ) );
	opCodeNameMap.insert( std::make_pair( 91, "load_unknown_6" ) );
	opCodeNameMap.insert( std::make_pair( 92, "load_unknown_7" ) );
	opCodeNameMap.insert( std::make_pair( 93, "load_null_32" ) );
	opCodeNameMap.insert( std::make_pair( 94, "load_unknown_8" ) );
	opCodeNameMap.insert( std::make_pair( 95, "load_bans_5" ) );
	opCodeNameMap.insert( std::make_pair( 96, "load_null_33" ) );
	opCodeNameMap.insert( std::make_pair( 97, "load_bans_6" ) );
	opCodeNameMap.insert( std::make_pair( 98, "load_font_q" ) );
	opCodeNameMap.insert( std::make_pair( 99, "load_null_34" ) );
	opCodeNameMap.insert( std::make_pair( 100, "load_info_point" ) );
	opCodeNameMap.insert( std::make_pair( 101, "load_unknown_9" ) );
	opCodeNameMap.insert( std::make_pair( 102, "load_null_35" ) );
	opCodeNameMap.insert( std::make_pair( 103, "load_font" ) );
	opCodeNameMap.insert( std::make_pair( 104, "load_unknown_10" ) );
	opCodeNameMap.insert( std::make_pair( 105, "load_unknown_11" ) );
	opCodeNameMap.insert( std::make_pair( 106, "load_glow_bans" ) );
	opCodeNameMap.insert( std::make_pair( 107, "load_slog_bans" ) );
	opCodeNameMap.insert( std::make_pair( 108, "load_font_or_ban" ) );
	opCodeNameMap.insert( std::make_pair( 109, "load_func_unknown" ) );
	opCodeNameMap.insert( std::make_pair( 110, "load_unknown_12" ) );
	opCodeNameMap.insert( std::make_pair( 111, "load_unknown_13" ) );
	opCodeNameMap.insert( std::make_pair( 112, "load_bans_7" ) );
	opCodeNameMap.insert( std::make_pair( 113, "load_func_28_muds_sub_q" ) );
	opCodeNameMap.insert( std::make_pair( 114, "load_null_36" ) );
	opCodeNameMap.insert( std::make_pair( 115, "load_null_37" ) );

	std::map< unsigned int, std::string >::iterator it = opCodeNameMap.find( aOpcode );
	if ( it != opCodeNameMap.end() )
	{
		std::cout << "OPCODE: " << it->second.c_str() << "\n";
	}
	else
	{
		std::cout << "UNKNOWN OPCODE: " << std::hex << aOpcode << "\n";
	}
}

// End of file
